/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class WebContent {
    private String inFileName_;
    private Vector files_;
    private ZipInputStream zipIn_;
    private byte[] zipBuf_;
    private static final String WEBCFG_FILE_NAME = "webcontent.cfg";

    public WebContent(String string) throws IOException {
        if (!string.toLowerCase().endsWith(".zip")) {
            throw new IOException("Unaccepted file type (must be .zip)");
        }
        this.inFileName_ = string;
        this.files_ = new Vector(5);
        this.zipBuf_ = new byte[0x100000];
    }

    public void extract(String string) throws IOException {
        this.files_.clear();
        this.openZipFile();
        ZipEntry zipEntry = null;
        while ((zipEntry = this.zipIn_.getNextEntry()) != null) {
            if (zipEntry.getName().toLowerCase().equals(WEBCFG_FILE_NAME)) {
                this.createFileList(string);
            } else {
                this.extractEntry(string, zipEntry.getName());
            }
            this.zipIn_.closeEntry();
        }
        this.closeZipFile();
    }

    public int getNumFiles() {
        return this.files_.size();
    }

    public WebContentFile getFile(int n) {
        if (n >= this.files_.size() || n < 0) {
            return null;
        }
        return (WebContentFile)this.files_.get(n);
    }

    private void openZipFile() throws IOException {
        this.zipIn_ = new ZipInputStream(new FileInputStream(this.inFileName_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeZipFile() {
        if (this.zipIn_ == null) {
            return;
        }
        try {
            this.zipIn_.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.zipIn_ = null;
        }
    }

    private void extractEntry(String string, String string2) throws IOException {
        Arrays.fill(this.zipBuf_, (byte)0);
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string, string2));
        int n = 0;
        while (n > -1) {
            fileOutputStream.write(this.zipBuf_, 0, n);
            fileOutputStream.flush();
            n = this.zipIn_.read(this.zipBuf_, 0, this.zipBuf_.length);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createFileList(String string) throws IOException {
        Arrays.fill(this.zipBuf_, (byte)0);
        int n = 0;
        int n2 = 0;
        while (n > -1) {
            n = this.zipIn_.read(this.zipBuf_, 0, this.zipBuf_.length);
            if (n <= 0) continue;
            n2 += n;
        }
        if (n2 <= 0) {
            System.out.println("webcontent.cfg empty!");
            return;
        }
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.zipBuf_[i];
        }
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        properties.load(byteArrayInputStream);
        byteArrayInputStream.close();
        for (int i = 1; i <= 6; ++i) {
            String string2 = "WEB" + i;
            String string3 = properties.getProperty(string2, "").trim();
            if (string3.length() <= 0) continue;
            this.files_.add(new WebContentFile(string, string3, string2));
        }
    }
}

